package edu.bjtu.groupone.backend.mapper;


import edu.bjtu.groupone.backend.domain.entity.User;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface UserMapper {

    @Select("select * from user where email=#{email} and password=#{password}")
     User login(User user);

     @Select("SELECT * FROM user WHERE username = #{username}")
    User selectByUsername(String username);

    @Select("SELECT * FROM user WHERE user_id = #{userId}")
    User selectUserById(int userId);

    @Select("SELECT * FROM user WHERE email = #{email}")
    User selectByEmail(String email);

    @Insert("INSERT INTO user(username, email, password, registration_date, identification_number) " +
            "VALUES(#{username}, #{email}, #{password}, #{registrationDate}, #{identificationNumber})")
    @Options(useGeneratedKeys = true, keyProperty = "userId")
    void insertUser(User user);

    @Update("UPDATE `user` SET password = #{password} WHERE email = #{email}")
    int updatePasswordByEmail(@Param("email") String email,
                              @Param("password") String password);

    @Select("SELECT COUNT(*) FROM user WHERE identification_number = #{identificationNumber}")
    int countByIdentificationNumber(int identificationNumber);

    @Delete("DELETE FROM user WHERE user_id = #{userId}")
    int deleteUser(int userId);

    @Update("UPDATE user SET username=#{username}, email=#{email}, password=#{password}, " +
            "identification_number=#{identificationNumber} WHERE user_id=#{userId}")
    int updateUser(User user);

    @Select("SELECT * FROM user")
    List<User> selectAllUsers();

    @Select({"SELECT * FROM user WHERE userid = #{id}"})
    User selectById(@Param("id") Long id);
}
