// WorkMapper.java
package edu.bjtu.groupone.backend.mapper;

//import edu.bjtu.groupone.backend.model.Work;
import edu.bjtu.groupone.backend.domain.entity.Work;
import org.apache.ibatis.annotations.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable; // 正确导入
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface WorkMybatisMapper  {
    // 修正参数类型为 Spring Data 的 Pageable
    Page<Work> findByCategoryIdIn(List<Long> categoryIds, Pageable pageable);
    @Insert("INSERT INTO works(title, author, views, category_id, description, create_time) " +
            "VALUES(#{title}, #{author}, #{views}, #{category.id}, #{description}, #{createTime})")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    void save(Work work);

    // 删除
    @Delete("DELETE FROM works WHERE id = #{id}")
    void deleteById(Long id);

    // 更新
    @Update("UPDATE works SET title=#{title}, author=#{author}, " +
            "views=#{views}, category_id=#{category.id}, " +
            "description=#{description}, create_time=#{createTime} " +
            "WHERE id=#{id}")
    void update(Work work);

    // 查询
    @Select("SELECT * FROM works WHERE id = #{id}")
    Work findById(Long id);
}