package edu.bjtu.groupone.backend.service;

import edu.bjtu.groupone.backend.domain.dto.CategoryDTO;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.mapper.CategoryMybatisMapper;
//import edu.bjtu.groupone.backend.model.Category;
import edu.bjtu.groupone.backend.utils.TreeBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class CategoryService {
    @Autowired
    private CategoryMybatisMapper categoryMybatisMapper;

    public List<CategoryDTO> getCategoryTree() {
        List<Category> allCategories = categoryMybatisMapper.findAll();
        return TreeBuilder.buildTree(allCategories);
    }

    public List<Long> getAllSubcategoryIds(Long categoryId) {
        // 获取所有子分类（包含自身）
        List<Long> ids = new ArrayList<>();
        if (categoryId != null) {
            ids.add(categoryId);
            findSubIds(categoryId, ids);
        }
        return ids;
    }

    private void findSubIds(Long parentId, List<Long> result) {
        List<Category> children = categoryMybatisMapper.findByParentId(parentId);
        for (Category child : children) {
            result.add(child.getId());
            findSubIds(child.getId(), result); // 递归查找子分类
        }
    }

    public void addCategory(Category category) {
        categoryMybatisMapper.insert(category);
    }

    public void deleteCategory(Long id) {
        categoryMybatisMapper.deleteById(id);
    }

    public void updateCategory(Category category) {
        categoryMybatisMapper.update(category);
    }

    public Category getCategoryById(Long id) {
        return categoryMybatisMapper.findById(id);
    }
}
