package edu.bjtu.groupone.backend.utils;

import com.turn.ttorrent.bcodec.BDecoder;
import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.bcodec.BEncoder;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class TorrentParserUtil {
    public TorrentParserUtil() {
    }

    public static Map<String, Object> parseTorrent(InputStream inputStream) throws Exception {
        Map<String, Object> result = new HashMap();
        BEValue rootBev = BDecoder.bdecode(inputStream);
        Map<String, BEValue> root = rootBev.getMap();
        Map<String, BEValue> info = ((BEValue)root.get("info")).getMap();
        String name = ((BEValue)info.get("name")).getString();
        long length = info.containsKey("length") ? ((BEValue)info.get("length")).getLong() : -1L;
        ByteBuffer buffer = BEncoder.bencode(info);
        byte[] encodedInfo = new byte[buffer.remaining()];
        buffer.get(encodedInfo);
        String infoHash = DigestUtils.sha1Hex(encodedInfo);
        result.put("infoHash", infoHash);
        result.put("name", name);
        result.put("length", length);
        return result;
    }
}
