package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.api.CategoryController;
import edu.bjtu.groupone.backend.domain.dto.CategoryDTO;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.service.CategoryService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class CategoryControllerTest {

    @Mock
    private CategoryService categoryService;

    @InjectMocks
    private CategoryController categoryController;

    private Category testCategory;

    @BeforeEach
    void setUp() {
        testCategory = new Category();
        testCategory.setId(1L);
        testCategory.setName("Test Category");
    }

    @Test
    void createCategory_shouldReturnSuccess() {
        // 调用
        ResponseEntity<String> response = categoryController.createCategory(testCategory);

        // 验证
        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals("分区创建成功", response.getBody());
        verify(categoryService, times(1)).addCategory(any(Category.class));
    }

    @Test
    void deleteCategory_shouldReturnSuccess() {
        // 调用
        ResponseEntity<String> response = categoryController.deleteCategory(1L);

        // 验证
        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals("分区删除成功", response.getBody());
        verify(categoryService, times(1)).deleteCategory(1L);
    }

    @Test
    void updateCategory_shouldReturnSuccess() {
        // 调用
        ResponseEntity<String> response = categoryController.updateCategory(1L, testCategory);

        // 验证
        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals("分区更新成功", response.getBody());
        verify(categoryService, times(1)).updateCategory(any(Category.class));
    }

    @Test
    void getCategory_shouldReturnCategory() {
        // 模拟
        when(categoryService.getCategoryById(1L)).thenReturn(testCategory);

        // 调用
        ResponseEntity<Category> response = categoryController.getCategory(1L);

        // 验证
        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(testCategory, response.getBody());
        verify(categoryService, times(1)).getCategoryById(1L);
    }

    @Test
    void getCategories_shouldReturnTree() {
        // 模拟
        CategoryDTO root = new CategoryDTO(1L, "Root");
        root.getChildren().add(new CategoryDTO(2L, "Child"));
        when(categoryService.getCategoryTree()).thenReturn(List.of(root));

        // 调用
        ResponseEntity<List<CategoryDTO>> response = categoryController.getCategories();

        // 验证
        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(1, response.getBody().size());
        assertEquals(1, response.getBody().get(0).getChildren().size());
        verify(categoryService, times(1)).getCategoryTree();
    }
}