package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.dto.CategoryDTO;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.mapper.CategoryMybatisMapper;
import edu.bjtu.groupone.backend.service.CategoryService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class CategoryServiceTest {

    @Mock
    private CategoryMybatisMapper mapper;

    @InjectMocks
    private CategoryService service;

    private Category parentCategory;
    private Category childCategory;

    @BeforeEach
    void setUp() {
        // 修复：使用带初始化的构造器
        parentCategory = new Category(1L, "Parent", null);
        childCategory = new Category(2L, "Child", parentCategory);

        // 修复：确保添加子节点前列表已初始化
        parentCategory.addChild(childCategory);
    }

    // 以下测试方法保持不变...
    @Test
    void addCategory_shouldCallMapper() {
        service.addCategory(parentCategory);
        verify(mapper, times(1)).insert(parentCategory);
    }

    @Test
    void deleteCategory_shouldCallMapper() {
        service.deleteCategory(1L);
        verify(mapper, times(1)).deleteById(1L);
    }

    @Test
    void updateCategory_shouldCallMapper() {
        service.updateCategory(parentCategory);
        verify(mapper, times(1)).update(parentCategory);
    }

    @Test
    void getCategoryById_shouldReturnCategory() {
        when(mapper.findById(1L)).thenReturn(parentCategory);
        Category result = service.getCategoryById(1L);
        assertEquals(parentCategory, result);
        verify(mapper, times(1)).findById(1L);
    }

    @Test
    void getCategoryTree_shouldBuildTree() {
        when(mapper.findAll()).thenReturn(Arrays.asList(parentCategory, childCategory));
        List<CategoryDTO> result = service.getCategoryTree();
        assertEquals(1, result.size());
        assertEquals(1, result.get(0).getChildren().size());
        verify(mapper, times(1)).findAll();
    }

    @Test
    void getAllSubcategoryIds_shouldReturnIds() {
        when(mapper.findByParentId(1L)).thenReturn(Collections.singletonList(childCategory));
        when(mapper.findByParentId(2L)).thenReturn(Collections.emptyList());
        List<Long> ids = service.getAllSubcategoryIds(1L);
        assertEquals(2, ids.size());
        assertTrue(ids.contains(1L));
        assertTrue(ids.contains(2L));
    }
}