package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.entity.User;
import edu.bjtu.groupone.backend.mapper.UserMapper;
import edu.bjtu.groupone.backend.service.impl.UserServImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyInt;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class UserServiceImplTest {

    @Mock
    private UserMapper userMapper;

    @InjectMocks
    private UserServImpl userService;

    private User testUser;

    @BeforeEach
    void setUp() {
        testUser = new User();
        testUser.setUserId(1);
        testUser.setUsername("testuser");
        testUser.setEmail("test@example.com");
    }

    @Test
    void deleteUser_shouldCallMapper() {
        // 模拟
        when(userMapper.deleteUser(1)).thenReturn(1);

        // 调用
        userService.deleteUser(1);

        // 验证
        verify(userMapper, times(1)).deleteUser(1);
    }

    @Test
    void updateUser_shouldCallMapper() {
        // 模拟
        when(userMapper.updateUser(any(User.class))).thenReturn(1);

        // 调用
        userService.updateUser(testUser);

        // 验证
        verify(userMapper, times(1)).updateUser(any(User.class));
    }

    @Test
    void getUserById_shouldReturnUser() {
        // 模拟
        when(userMapper.selectUserById(1)).thenReturn(testUser);

        // 调用
        User result = userService.getUserById(1);

        // 验证
        assertEquals(testUser, result);
        verify(userMapper, times(1)).selectUserById(1);
    }

    @Test
    void getAllUsers_shouldReturnList() {
        // 模拟
        List<User> users = Arrays.asList(testUser, new User());
        when(userMapper.selectAllUsers()).thenReturn(users);

        // 调用
        List<User> result = userService.getAllUsers();

        // 验证
        assertEquals(2, result.size());
        verify(userMapper, times(1)).selectAllUsers();
    }
}