package edu.bjtu.groupone.backend.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.sql.DataSource;
import java.sql.Connection;

@Tag(name = "数据库测试", description = "用于检测后端 DataSource 是否能正常连接数据库")
@RestController
@RequestMapping("/api/dbtest")
public class DbTestController {

    @Autowired
    private DataSource dataSource;

    @Operation(summary = "测试数据库连接", description = "尝试获取 Connection 并返回 JDBC URL")
    @ApiResponses({
            @ApiResponse(
                    responseCode = "200",
                    description = "成功连接数据库",
                    content = @Content(
                            mediaType = "text/plain",
                            examples = @ExampleObject(
                                    name = "连接成功示例",
                                    value = "✅ 成功连接数据库：jdbc:mysql://localhost:3306/groupone_db"
                            )
                    )
            ),
            @ApiResponse(
                    responseCode = "500",
                    description = "无法连接数据库",
                    content = @Content(
                            mediaType = "text/plain",
                            examples = @ExampleObject(
                                    name = "连接失败示例",
                                    value = "❌ 无法连接数据库：Communications link failure"
                            )
                    )
            )
    })
    @GetMapping("/db")
    public String testDb() {
        try (Connection conn = dataSource.getConnection()) {
            return "✅ 成功连接数据库：" + conn.getMetaData().getURL();
        } catch (Exception e) {
            return "❌ 无法连接数据库：" + e.getMessage();
        }
    }
}