package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.entity.Post;
import edu.bjtu.groupone.backend.domain.entity.Result;
import edu.bjtu.groupone.backend.service.PostService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@CrossOrigin
@Tag(name = "帖子相关接口")
@RestController
@RequestMapping("/api/post")
public class PostController {

    @Autowired
    private PostService postService;

    @Operation(summary = "添加帖子")
    @PostMapping("/posts")
    public Result<String> addPost(@RequestBody Post post) {
        postService.addPost(post);
        return Result.success("帖子添加成功");
    }

    @Operation(summary = "删除帖子")
    @DeleteMapping("/posts/{postId}")
    public Result<String> deletePost(@PathVariable Long postId) {
        postService.deletePost(postId);
        return Result.success("帖子删除成功");
    }

    @Operation(summary = "更新帖子")
    @PutMapping("/posts/{postId}")
    public Result<String> updatePost(@PathVariable Long postId, @RequestBody Post post) {
        post.setPostId(postId);
        postService.updatePost(post);
        return Result.success("帖子更新成功");
    }

    @Operation(summary = "获取帖子详情")
    @GetMapping("/posts/{postId}")
    public Result<Post> getPost(@PathVariable Long postId) {
        return Result.success(postService.getPostById(postId));
    }

    @Operation(summary = "获取所有帖子")
    @GetMapping("/posts")
    public Result<List<Post>> getAllPosts() {
        return Result.success(postService.getAllPosts());
    }
}