package edu.bjtu.groupone.backend.api;

import edu.bjtu.groupone.backend.domain.UserRole;
import edu.bjtu.groupone.backend.service.UserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/user-roles")
public class UserRoleController {
    @Autowired
    private UserRoleService userRoleService;

    @GetMapping("/{userId}")
    public ResponseEntity<List<UserRole>> getUserRoles(@PathVariable Long userId) {
        return ResponseEntity.ok(userRoleService.getUserRolesByUserId(userId));
    }

    @GetMapping("/{userId}/is-admin")
    public ResponseEntity<Boolean> isAdmin(@PathVariable Long userId) {
        return ResponseEntity.ok(userRoleService.isAdmin(userId));
    }

    @PostMapping
    public ResponseEntity<Integer> addUserRole(@RequestBody UserRole userRole) {
        return ResponseEntity.ok(userRoleService.addUserRole(userRole));
    }
} 