package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.mapper.CategoryMybatisMapper;
//import edu.bjtu.groupone.backend.model.Category;
import edu.bjtu.groupone.backend.service.CategoryService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.*;

class CategoryServiceTest {

    @Mock
    private CategoryMybatisMapper mapper;

    @InjectMocks
    private CategoryService service;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void testGetAllSubcategoryIds() {
        Category child = new Category(2L, "Child", new Category(1L, "Parent", null));
        when(mapper.findByParentId(1L)).thenReturn(List.of(child));
        when(mapper.findByParentId(2L)).thenReturn(List.of());

        List<Long> ids = service.getAllSubcategoryIds(1L);

        assertEquals(List.of(1L, 2L), ids);
    }
}
