package edu.bjtu.groupone.backend;

import edu.bjtu.groupone.backend.domain.dto.WorkResponse;
import edu.bjtu.groupone.backend.domain.entity.Category;
import edu.bjtu.groupone.backend.domain.entity.Work;
import edu.bjtu.groupone.backend.mapper.WorkMybatisMapper;
//import edu.bjtu.groupone.backend.model.Category;
//import edu.bjtu.groupone.backend.model.Work;
import edu.bjtu.groupone.backend.service.CategoryService;
import edu.bjtu.groupone.backend.service.WorkService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.*;
import org.springframework.data.domain.*;

import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.*;

class WorkServiceTest {

    @Mock
    private WorkMybatisMapper mapper;

    @Mock
    private CategoryService categoryService;

    @InjectMocks
    private WorkService service;

    @BeforeEach
    void init() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void testGetWorks() {
        Long categoryId = 1L;
        List<Long> categoryIds = List.of(categoryId);

        Work mockWork = Work.builder()
                .id(10L)
                .title("Test Title")
                .author("Author")
                .views(123)
                .category(Category.builder().id(categoryId).name("Test").build())
                .build();

        Page<Work> workPage = new PageImpl<>(List.of(mockWork));
        when(categoryService.getAllSubcategoryIds(categoryId)).thenReturn(categoryIds);
        when(mapper.findByCategoryIdIn(eq(categoryIds), any(Pageable.class))).thenReturn(workPage);

        Page<WorkResponse> result = service.getWorks(categoryId, 1, 10);
        assertEquals(1, result.getTotalElements());
        assertEquals("Test Title", result.getContent().get(0).getTitle());
    }
}
