package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;

@Data
@Schema(description = "邮箱请求参数")
public class EmailRequest {

    @NotNull(message = "邮箱不能为空")
    @Email(message = "请输入有效的邮箱地址")
    @Schema(description = "用户邮箱", required = true, example = "john@example.com")
    private String email;
}    