package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;

@Data
@Schema(description = "用户登录请求参数")
public class LoginRequest {

    @NotNull(message = "邮箱不能为空")
    @Email(message = "请输入有效的邮箱地址")
    @Schema(description = "用户邮箱", required = true, example = "john@example.com")
    private String email;

    @NotNull(message = "密码不能为空")
    @Schema(description = "用户密码", required = true, example = "password123")
    private String password;
}    