package edu.bjtu.groupone.backend.domain.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;

@Data
@Schema(description = "重置密码请求参数")
public class ResetPasswordRequest {

    @NotNull(message = "邮箱不能为空")
    @Email(message = "请输入有效的邮箱地址")
    @Schema(description = "用户邮箱", required = true, example = "john@example.com")
    private String email;

    @NotNull(message = "验证码不能为空")
    @Schema(description = "重置密码验证码", required = true, example = "654321")
    private String code;

    @NotNull(message = "新密码不能为空")
    @Schema(description = "新密码", required = true, example = "newPassword123")
    private String newPassword;
}    