import { Card, Flex } from "antd";
import { Outlet } from "react-router";
import auth_background from "../../assets/auth_background.png"
import slogan from "../../assets/slogan.png"
function AuthLayout() {

    return (
        <Flex gap="20px" justify="center">
            <div
                style={{
                    width: '45%',
                    height: '80vh',
                    backgroundImage: `url(${auth_background})`,
                    backgroundSize: 'cover',
                    backgroundPosition: 'center',
                    borderRadius: '12px',
                    position: 'relative',
                }}
            >
                {/* <h1>
                    登录创驿
                </h1>
                <p>
                    与众多用户和创作者一起交流
                </p> */}
            </div>
            <Flex
                style={{ width: 400, height: '80vh' }}
                vertical
                gap="20px"
                justify="space-between"
            >
                <Card>
                    <Outlet></Outlet>
                </Card>
                <Card style={{ padding: 0, margin: 0 }}>
                    <img src={slogan} width="100%" />
                </Card>
            </Flex>
        </Flex>
    );
}

export default AuthLayout;    