import { MailOutlined, LockOutlined } from '@ant-design/icons';
import { Button, Form, Input, message, Row, Col } from 'antd';
import { NavLink } from 'react-router';
import { useState, useEffect } from 'react';

function Forget() {
    const [countdown, setCountdown] = useState(0);
    const [emailSent,] = useState(false);

    const onFinish = async () => {

    };

    useEffect(() => {
        let countdownTimer = null;

        if (countdown > 0) {
            countdownTimer = setTimeout(() => {
                setCountdown(prev => prev - 1);
            }, 1000);
        }

        return () => {
            if (countdownTimer) {
                clearTimeout(countdownTimer);
            }
        };
    }, [countdown]);

    const resendCode = () => {
        if (countdown > 0) return;
        setCountdown(60);
        message.info('验证码已重新发送');
    };

    return (
        <Form
            name="forget"
            initialValues={{ remember: true }}
            style={{ maxWidth: 360 }}
            onFinish={onFinish}
        >
            <h2>重置密码</h2>
            <p>请输入您注册时使用的邮箱地址</p>

            <Form.Item
                name="email"
                rules={[
                    { required: true, message: '请输入您的邮箱！' },
                    { type: 'email', message: '请输入正确的邮箱格式' }
                ]}
            >
                <Input prefix={<MailOutlined />} placeholder="注册邮箱" />
            </Form.Item>

            {emailSent && (
                <>
                    <Form.Item
                        name="code"
                        rules={[{ required: true, message: '请输入验证码！' }]}
                    >
                        <Row gutter={8}>
                            <Col span={16}>
                                <Input placeholder="验证码" />
                            </Col>
                            <Col span={8}>
                                <Button
                                    disabled={countdown > 0}
                                    onClick={resendCode}
                                    style={{ width: '100%' }}
                                >
                                    {countdown > 0 ? `${countdown}s后重试` : '重新发送'}
                                </Button>
                            </Col>
                        </Row>
                    </Form.Item>

                    <Form.Item
                        name="password"
                        rules={[
                            { required: true, message: '请设置新密码！' },
                            { min: 6, message: '密码长度至少为6位' }
                        ]}
                    >
                        <Input.Password prefix={<LockOutlined />} placeholder="新密码" />
                    </Form.Item>

                    <Form.Item
                        name="confirmPassword"
                        dependencies={['password']}
                        rules={[
                            { required: true, message: '请确认新密码！' },
                            ({ getFieldValue }) => ({
                                validator(_, value) {
                                    if (!value || getFieldValue('password') === value) {
                                        return Promise.resolve();
                                    }
                                    return Promise.reject(new Error('两次输入的密码不一致！'));
                                },
                            }),
                        ]}
                    >
                        <Input.Password prefix={<LockOutlined />} placeholder="确认新密码" />
                    </Form.Item>
                </>
            )}

            <Form.Item>
                <Button block type="primary" htmlType="submit">
                    {emailSent ? '确认重置' : '获取验证码'}
                </Button>
                或 <NavLink to='/login'>返回登录</NavLink>
            </Form.Item>
        </Form>
    );
}

export default Forget;    