
import { LockOutlined, MailOutlined } from '@ant-design/icons';
import { Button, Checkbox, Form, Input, Flex } from 'antd';
import { NavLink } from 'react-router';
function Login() {
    const onFinish = (values: unknown) => {
        console.log('Received values of form: ', values);
    };

    return (
        <Form
            name="login"
            initialValues={{ remember: true }}
            style={{ maxWidth: 360 }}
            onFinish={onFinish}
        >
            <h2>登录</h2>
            <Form.Item
                name="email"
                rules={[{ required: true, message: '请输入你的账号（注册邮箱）！' }, { type: 'email', message: '请输入正确的邮箱' }]}
            >
                <Input prefix={<MailOutlined />} placeholder="账号（注册邮箱）" />
            </Form.Item>
            <Form.Item
                name="password"
                rules={[{ required: true, message: '请输入你的密码！' }]}
            >
                <Input prefix={<LockOutlined />} type="password" placeholder="密码" />
            </Form.Item>
            <Form.Item>
                <Flex justify="space-between" align="center">
                    <Form.Item name="remember" valuePropName="checked" noStyle>
                        <Checkbox>自动登录</Checkbox>
                    </Form.Item>
                    <NavLink to='/forget'> 忘记密码 </NavLink>

                </Flex>
            </Form.Item>

            <Form.Item>
                <Button block type="primary" htmlType="submit">
                    登录
                </Button>
                或 <NavLink to='/register'>注册</NavLink>
            </Form.Item>
        </Form>
    );
};

export default Login;