import type { AxiosResponse } from "axios";
import axios from "axios";
import type { UserDetailInfo, UserInfo } from "./type";
import type { CommonResponse } from "../type";

class UserAPi {
    static getMe() :Promise<AxiosResponse<CommonResponse<UserInfo>>> {
        return axios.get('/api/user/me');
    }

    static getMeDetail(userid:string) :Promise<AxiosResponse<CommonResponse<UserDetailInfo>>> {
        return axios.get(`/api/user/${userid}`);
    }
}


export default UserAPi;