import { Outlet, useLocation, useNavigate } from 'react-router';
import { Layout, Menu } from 'antd';
import { HomeOutlined, AppstoreOutlined } from '@ant-design/icons';

const { Header } = Layout;

const AppLayout = () => {
    const location = useLocation();
    const navigate = useNavigate();
    // 导航项配置
    const menuItems = [
        {
            key: 'home',
            label: '主页',
            icon: <HomeOutlined />,
            path: '/',
        },
        {
            key: 'tasks',
            label: '任务清单',
            icon: <AppstoreOutlined />,
            path: '/tasks',
        },
    ];

    return (
        <Layout style={{ minHeight: '100vh', width: '100%' }}>
            <Header className="header" style={{ display: 'flex', alignItems: 'center' }}>
                <div className="logo" color='white'>创驿</div>
                <Menu
                    mode="horizontal"
                    theme='dark'
                    selectedKeys={[location.pathname === '/' ? 'home' : location.pathname.slice(1)]}
                    items={menuItems.map(item => ({
                        ...item,
                        onClick: () => navigate(item.path),
                    }))}
                />
            </Header>
            <Layout.Content style={{ padding: '24px' }}>
                <Outlet />
            </Layout.Content>
            <Layout.Footer>
                © 2025 创驿 - 创作路上的同行者
            </Layout.Footer>
        </Layout>
    );
};

export default AppLayout;    