import axios from "axios";

// 为所有auth外请求添加token头
axios.interceptors.request.use((config) => {
  const requestUrl = config.url;
  if (requestUrl?.includes("/auth/")) {
    config.url = requestUrl.replace("/auth/","/");
  } else {
    const token = localStorage.getItem('token');
    config.headers['Authorization'] = `Bearer ${token}`;
  }
  return config;
}, (error) => {
  return error;
} );

export default axios