import axios, { type AxiosResponse } from 'axios';
import type { RejisterRequest , ResetPasswordRequest} from './type';
import type{ LoginRequest } from './type';
import type { CommonResponse } from '../type';

class AuthAPI {

    static sendVerificationCode(email: string): Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/auth/sendVerification', { email });
    }

    static register(request: RejisterRequest): Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/auth/register', request);
    }

    static sendResetCode(email: string):Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/auth/sendResetCode', { email });
    }

    static resetPassword( request: ResetPasswordRequest ):Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/auth/resetPassword', request);
    }
    

    static refreshToken(oldToken : string): Promise<AxiosResponse<CommonResponse<string>>> {
        return axios.post(
            '/api/auth/refreshToken',
            {}, // 请求体空
            {
                headers: {
                    token: oldToken,
                },
            }
        );
    }
    
    
    static login(loginRequest: LoginRequest): Promise<AxiosResponse<CommonResponse<string>>> {
        return axios.post('/api/auth/login', loginRequest);
    }

}

export default AuthAPI;

