import { useCallback, useState } from "react";
import { useNavigate } from "react-router";
import type { 
    WorkFormData, 
    BasicInfo, 
    CoverInfo, 
    VersionFormData,
    ArtworkCategory
} from './types';

// ==================== Hook ====================
export const useCreateWorkForm = () => {
    const navigate = useNavigate();
    const [currentStep, setCurrentStep] = useState<number>(0);
    const [formData, setFormData] = useState<WorkFormData>({
        basicInfo: { 
            artworkName: '', 
            artworkCategory: '概念设计' as ArtworkCategory, 
            artworkDescription: '' 
        },
        coverInfo: {},
        versions: [],
    });

    const handleUpdateFormData = useCallback((field: keyof WorkFormData, value: BasicInfo | CoverInfo | VersionFormData[]) => {
        setFormData(prev => ({ ...prev, [field]: value }));
    }, []);

    const handleNext = useCallback(() => setCurrentStep(prev => Math.min(prev + 1, 3)), []);
    const handlePrev = useCallback(() => setCurrentStep(prev => Math.max(prev - 1, 0)), []);
    const handlePublish = useCallback(() => navigate('/work/new-work-id'), [navigate]);

    return { currentStep, formData, handleUpdateFormData, handleNext, handlePrev, handlePublish };
};