// src/routes/routes.ts

import { createBrowserRouter } from "react-router";
import Home from "../feature/home/Home";
import AuthLayout from "../feature/auth/AuthLayout";
import Login from "../feature/auth/Login";
import Register from "../feature/auth/Register";
import Forget from "../feature/auth/Forget";
import AppLayout from "../AppLayout";
import withProtect from "./withProtect";
import Work from "../feature/work/Work";
import CreateWork from "../feature/work/CreateWork";

// 创建受保护的组件
const ProtectedHome = withProtect(Home);
const ProtectedWork = withProtect(Work);
const ProtectedCreatWork = withProtect(CreateWork)
export default createBrowserRouter([
  {
    path: "/",
    Component: AppLayout,
    children: [
      {
        path: "/",
        Component: ProtectedHome,
      },
      {
        Component: AuthLayout,
        children: [
          { path: "/login", Component: Login },
          { path: "/register", Component: Register },
          { path: "/forget", Component: Forget },
        ],
      },
      {
        path: "/work/:work_id",
        Component: ProtectedWork,
      },
      {
        path:"/work/creat",
        Component: ProtectedCreatWork
      }
    ],
  },
]);