// src/routes/withProtect.ts

import React from 'react';
import ProtectedRoute from './ProtectedRoute';

const withProtect = <P extends object>(Component: React.ComponentType<P>) => {
  return function ProtectedComponent(props: P) {
    return React.createElement(ProtectedRoute, {
      children: React.createElement(Component, props)
    });
  };
};

export default withProtect;