import { render, screen } from '@testing-library/react'
import Forget from '../../feature/auth/Forget'
import { Provider } from 'react-redux'
import { store } from '../../store/store'
import { MemoryRouter } from 'react-router'

describe('Forget Password Page', () => {
    it('renders forget password form', () => {
        render(
            <MemoryRouter>
                <Provider store={store}>
                    <Forget />
                </Provider>
            </MemoryRouter>

        )

        const emailInput = screen.getByPlaceholderText('注册邮箱')
        const getCodeButton = screen.getByText('获取验证码')

        expect(emailInput).toBeInTheDocument()
        expect(getCodeButton).toBeInTheDocument()
    })
})