import { render, screen } from '@testing-library/react'
import Login from '../../feature/auth/Login'
import { Provider } from 'react-redux'
import { store } from '../../store/store'
import { MemoryRouter } from 'react-router'

describe('Login Page', () => {
  it('renders login form', () => {
    render(
      <MemoryRouter>
        <Provider store={store}>
          <Login />
        </Provider>
      </MemoryRouter>

    )

    const emailInput = screen.getByPlaceholderText('账号（注册邮箱）')
    const passwordInput = screen.getByPlaceholderText('密码')
    const loginButton = screen.getByRole('button', { name: /登录/i })


    expect(emailInput).toBeInTheDocument()
    expect(passwordInput).toBeInTheDocument()
    expect(loginButton).toBeInTheDocument()
  })
})