import axios, { type AxiosResponse } from 'axios';
import type { RejisterRequest , CommonResponse, ResetPasswordRequest} from './type';
import type{ LoginRequest } from './type';

class authAPI {

    static sendVerificationCode(email: string): Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/sendVerification', { email });
    }

    static register(request: RejisterRequest): Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/register', request);
    }

    static sendResetCode(email: string):Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/sendResetCode', { email });
    }

    static resetPassword( request: ResetPasswordRequest ):Promise<AxiosResponse<CommonResponse>> {
        return axios.post('/api/resetPassword', request);
    }
    

    static refreshToken(oldToken : string): Promise<AxiosResponse<CommonResponse<string>>> {
        return axios.post(
            '/api/refreshToken',
            {}, // 请求体空
            {
                headers: {
                    token: oldToken,
                },
            }
        );
    }
    
    
    static login(loginRequest: LoginRequest): Promise<AxiosResponse<CommonResponse<string>>> {
        return axios.post('/api/login', loginRequest);
    }

}

export default authAPI;

