import axios, { type AxiosResponse } from "axios";

// 为所有auth外请求添加token头
axios.interceptors.request.use((config) => {
  const requestUrl = config.url;
  if (requestUrl?.includes("/auth/")) {
    config.url = requestUrl.replace("/auth/","/");
  } else {
    const token = localStorage.getItem('token');
    config.headers['Authorization'] = `Bearer ${token}`;
  }
  return config;
}, (error) => {
  return error;
} );


// 统一响应拦截器
axios.interceptors.response.use(
  (response: AxiosResponse) => {
    const { code, msg, data } = response.data;

    return {
      ...response, // 保留原本的响应信息
      data: {
        code,
        message: msg,
        data,
        success: code === 0, // 根据 code 判断请求是否成功
      },
    };
  },
  (error) => {
    return {
      ...error.response, // 保留原本的错误响应信息
      data: {
        code: -1,
        message: error.message || '请求失败',
        data: null,
        success: false,
      },
    };
  }
);

export default axios