import { Card, Flex } from "antd";
import { Outlet } from "react-router";
import auth_background from "../../assets/auth_background.png"
import slogan from "../../assets/slogan.png"
function AuthLayout() {

    return (
        <Flex gap="20px" justify="center">
            <div
                style={{
                    width: '45%',
                    height: '80vh',
                    backgroundImage: `url(${auth_background})`,
                    backgroundSize: 'cover',
                    backgroundPosition: 'center',
                    borderRadius: '12px',
                    position: 'relative',
                }}
            >
                <Card style={{ padding: 0, margin: 0, background: 'rgba(255,255,255,0)', border: 'none' }}>
                    <img src={slogan} width="100%" />
                </Card>
            </div>
            <Flex
                style={{ width: 400, height: '80vh' }}
                vertical
                gap="20px"
                justify="space-between"
            >
                <Card>
                    <Outlet></Outlet>
                </Card>

            </Flex>
        </Flex>
    );
}

export default AuthLayout;    