import React from 'react';
import ReactDOM from 'react-dom/client';

// 状态管理 redux
import { store } from '../src/store/store.ts';
import { Provider } from 'react-redux';
// 路由 react-router
import routes from './routes.ts';
import { RouterProvider } from 'react-router';
// 组件库 ant
import '@ant-design/v5-patch-for-react-19';
import { ConfigProvider } from 'antd';
import zhCN from 'antd/locale/zh_CN';

import "./api/interceptors.ts";

import "./main.css"
ReactDOM.createRoot(document.getElementById('root')!).render(
  <React.StrictMode>
    <Provider store={store}>
      <ConfigProvider locale={zhCN}>
        <RouterProvider router={routes} />
      </ConfigProvider>
    </Provider>
  </React.StrictMode>
);