import { render, screen } from '@testing-library/react'
import Register from '../../feature/auth/Register'
import { Provider } from 'react-redux'
import { store } from '../../store/store'
import { MemoryRouter } from 'react-router'

describe('Register Page', () => {
    it('renders register form', () => {
        render(
            <MemoryRouter>
                <Provider store={store}>
                    <Register />
                </Provider>
            </MemoryRouter>

        )

        const nameInput = screen.getByPlaceholderText('请输入用户名')
        const emailInput = screen.getByPlaceholderText('请输入邮箱')
        const verifyCodeInput = screen.getByPlaceholderText('请输入验证码')
        const passwordInput = screen.getByPlaceholderText('请输入密码')
        const confirmPasswordInput = screen.getByPlaceholderText('请确认密码')
        const registerButton = screen.getByText('注册')

        expect(nameInput).toBeInTheDocument()
        expect(emailInput).toBeInTheDocument()
        expect(verifyCodeInput).toBeInTheDocument()
        expect(passwordInput).toBeInTheDocument()
        expect(confirmPasswordInput).toBeInTheDocument()
        expect(registerButton).toBeInTheDocument()
    })
})