import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import { configDefaults } from 'vitest/config'

export default defineConfig({
  plugins: [react()],
  // dev时执行的端口转发
  server: {
    proxy: {
      '/api': {
        target: 'http://localhost:8080/',
        changeOrigin: true,
        rewrite: (path:string) => path.replace(/^\/api/, ''),
      },
    },
  },
  test: {
    ...configDefaults,
    globals:true,
    environment: 'jsdom',  // 确保测试环境为 jsdom
    setupFiles: './src/test/setup.ts',  // 设置你的初始化文件
  },
})
