import React, { useMemo } from 'react';
import { Layout, Steps, Card, Typography } from 'antd';
import { FileTextOutlined, FileImageOutlined, SaveOutlined, SendOutlined } from '@ant-design/icons';
import { BasicInfoStep, CoverUploadStep, VersionManagementStep, ConfirmPublishStep } from './CreatWorkComponents';
import { useCreateWorkForm } from './hooks';


const { Content } = Layout;
const { Title, Paragraph } = Typography;

const CreateWork: React.FC = () => {
    const { currentStep, formData, handleUpdateFormData, handleNext, handlePrev, handlePublish } = useCreateWorkForm();

    const steps = useMemo(() => [
        { title: '基础信息', description: '填写作品基本信息', icon: <FileTextOutlined /> },
        { title: '上传封面', description: '上传作品封面图片', icon: <FileImageOutlined /> },
        { title: '版本管理', description: '添加作品版本和文件', icon: <SaveOutlined /> },
        { title: '确认发布', description: '检查并发布作品', icon: <SendOutlined /> },
    ], []);

    const renderStepContent = useMemo(() => {
        const commonProps = { data: formData, onUpdate: handleUpdateFormData, onNext: handleNext, onPrev: handlePrev };

        switch (currentStep) {
            case 0: return <BasicInfoStep {...commonProps} />;
            case 1: return <CoverUploadStep {...commonProps} />;
            case 2: return <VersionManagementStep {...commonProps} />;
            case 3: return <ConfirmPublishStep {...commonProps} onPublish={handlePublish} />;
            default: return null;
        }
    }, [currentStep, formData, handleUpdateFormData, handleNext, handlePrev, handlePublish]);

    return (
        <Layout style={{ minHeight: '100vh', backgroundColor: '#f5f5f5' }}>
            <Content style={{ padding: '20px' }}>
                <div style={{ maxWidth: 1000, margin: '0 auto' }}>
                    <Card style={{ marginBottom: 24 }}>
                        <Title level={2} style={{ marginBottom: 8 }}>创建新作品</Title>
                        <Paragraph type="secondary">通过以下步骤发布您的创意作品，与社区分享您的才华</Paragraph>
                    </Card>

                    <Card style={{ marginBottom: 24 }}>
                        <Steps current={currentStep} items={steps} />
                    </Card>

                    {renderStepContent}
                </div>
            </Content>
        </Layout>
    );
};

export default CreateWork;