import axios from 'axios';

const BASE_URL = 'http://localhost:8080/chat';  // 根据你的后端接口地址调整

// 发送消息
export const sendMessage = async ({ senderId, receiverId, content }) => {
    const now = new Date().toISOString(); // 发送时间

    // 构造后端需要的格式，chatimformation1 或 chatimformation2 中只有一个有值
    const payload = {
        friend1: senderId,
        friend2: receiverId,
        talkTime: now,
        chatimformation1: senderId < receiverId ? content : null, // 约定较小 ID 为 friend1 发送的消息
        chatimformation2: senderId > receiverId ? content : null,
    };

    const response = await axios.post(`${BASE_URL}/create`, payload);
    return response.data;
};

// 获取两个用户之间的聊天记录
export const getMessagesByUserIds = async (senderId, receiverId) => {
    const response = await axios.get(`${BASE_URL}/between`, {
        params: {
            user1: senderId,
            user2: receiverId,
        }
    });
    return response.data;
};

// 可选：获取某用户与所有人的聊天记录（如果你后续需要聊天列表用）
export const getChatsByUser = async (userId) => {
    const response = await axios.get(`${BASE_URL}/user/${userId}`);
    return response.data;
};
