import axios from 'axios';

const BASE_URL = 'http://localhost:8080/friends';

// 添加好友
export const addFriend = (friendData) => {
    return axios.post(`${BASE_URL}/add`, friendData);
};

// ✅ 删除好友（通过 friend1 和 friend2 双向删除）
export const deleteFriend = (friend1, friend2) => {
    return axios.delete(`${BASE_URL}/delete`, {
        params: { friend1, friend2 }
    });
};

// 查询某个用户的所有好友（friend1 或 friend2）
export const getFriendsByUserId = (userid) => {
    return axios.get(`${BASE_URL}/list/${userid}`);
};
