// src/components/ActivityFullList.jsx
import React, { useEffect, useState } from 'react';
import { getFullActivities } from '../api/activity';

const ActivityFullList = () => {
    const [activities, setActivities] = useState([]);

    useEffect(() => {
        getFullActivities()
            .then(res => setActivities(res.data))
            .catch(err => console.error('获取完整活动失败:', err));
    }, []);

    return (
        <div>
            <h2>完整活动信息</h2>
            <div style={{ display: 'flex', flexDirection: 'column', gap: '24px' }}>
                {activities.map(activity => (
                    <div key={activity.activityid} style={{ borderBottom: '1px solid #ddd', paddingBottom: '16px' }}>
                        <h3>{activity.title}</h3>
                        <img
                            src={activity.photo}
                            alt={activity.title}
                            style={{ width: '300px', height: 'auto', borderRadius: '4px' }}
                        />
                        <p><strong>内容：</strong>{activity.content}</p>
                        <p><strong>时间：</strong>{activity.time}</p>
                        <p><strong>奖励：</strong>{activity.award}</p>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default ActivityFullList;
