// src/components/ActivityPreview.jsx
import React, { useEffect, useState } from 'react';
import { getActivityPreviews } from '../api/activity';

const ActivityPreview = () => {
    const [activities, setActivities] = useState([]);

    useEffect(() => {
        getActivityPreviews()
            .then(res => setActivities(res.data))
            .catch(err => console.error('获取活动预览失败:', err));
    }, []);

    return (
        <div>
            <h2>活动预览</h2>
            <div style={{ display: 'flex', flexWrap: 'wrap', gap: '16px' }}>
                {activities.map(activity => (
                    <div key={activity.activityid} style={{ border: '1px solid #ccc', padding: '12px', borderRadius: '8px' }}>
                        <h3>{activity.title}</h3>
                        <img
                            src={activity.photo}
                            alt={activity.title}
                            style={{ width: '200px', height: 'auto', borderRadius: '4px' }}
                        />
                    </div>
                ))}
            </div>
        </div>
    );
};

export default ActivityPreview;
