import axios from 'axios';

const BASE_URL = 'http://localhost:8080/request';

// 创建求助帖（支持上传图片）
export const createRequest = (formData) => {
    return axios.post(`${BASE_URL}/create`, formData, {
        headers: {
            'Content-Type': 'multipart/form-data',
        },
    });
};

// 修改求助帖金额
export const updateMoney = (requestid, money) => {
    return axios.put(`${BASE_URL}/updateMoney/${requestid}`, null, {
        params: { money },
    });
};

// ✅ 新增：根据名称批量更新被协助用户 ID
export const updateLoaduserByName = (name, loaduser) => {
    return axios.post(`${BASE_URL}/updateLoaduserByName`, null, {
        params: { name, loaduser },
    });
};

// 删除求助帖
export const deleteRequest = (requestid) => {
    return axios.delete(`${BASE_URL}/delete/${requestid}`);
};

// 根据名称查找求助帖
export const findByName = async (name) => {
    try {
        const response = await axios.get(`${BASE_URL}/findByName`, {
            params: { name },
        });
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('按名称查找求助帖失败', error);
        return [];
    }
};

// 根据发帖用户 ID 查找求助帖
export const findByUserid = async (userid) => {
    try {
        const response = await axios.get(`${BASE_URL}/findByUserid`, {
            params: { userid },
        });
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('按用户ID查找求助帖失败', error);
        return [];
    }
};

// 根据被协助用户 ID 查找求助帖
export const findByLoaduser = async (loaduser) => {
    try {
        const response = await axios.get(`${BASE_URL}/findByLoaduser`, {
            params: { loaduser },
        });
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('按被协助用户ID查找求助帖失败', error);
        return [];
    }
};

// 获取某名称的总金额
export const getTotalMoneyByName = async (name) => {
    try {
        const response = await axios.get(`${BASE_URL}/totalMoneyByName`, {
            params: { name },
        });
        return typeof response.data === 'number' ? response.data : 0;
    } catch (error) {
        console.error('获取总金额失败', error);
        return 0;
    }
};

export const getAllRequests = async () => {
    try {
        const response = await axios.get(`${BASE_URL}/all`);
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('获取全部求助帖失败', error);
        return [];
    }
};
