// TorrentList.test.jsx
import React from 'react';
import { render, screen, fireEvent, waitFor } from '@testing-library/react';
import TorrentList from '../components/TorrentList';
import axios from 'axios';
import { MemoryRouter } from 'react-router-dom'; // ✅ 引入 MemoryRouter


import { vi } from 'vitest';
beforeAll(() => {
  Object.defineProperty(window, 'matchMedia', {
    writable: true,
    value: vi.fn().mockImplementation((query) => ({
      matches: false,
      media: query,
      onchange: null,
      addListener: vi.fn(),
      removeListener: vi.fn(),
      addEventListener: vi.fn(),
      removeEventListener: vi.fn(),
      dispatchEvent: vi.fn(),
    })),
  });
});

vi.mock('axios');



describe('TorrentList - 搜索功能', () => {
  test('搜索关键词后应正确调用接口并显示结果', async () => {
    const mockTorrents = [
      { id: 1, title: '测试种子1', uploader_id: 123 },
      { id: 2, title: '测试种子2', uploader_id: 456 },
    ];

    axios.get.mockResolvedValueOnce({ data: mockTorrents });

    render(
      <MemoryRouter>
        <TorrentList />
      </MemoryRouter>
    );

    // 输入关键词
    const input = screen.getByPlaceholderText(/搜索种子/i);
    fireEvent.change(input, { target: { value: '测试' } });

    // 模拟点击搜索按钮
    const button = screen.getByRole('button', { name: /搜\s*索/i });
    fireEvent.click(button);


    // 等待并断言结果被渲染
    await waitFor(() => {
      expect(axios.get).toHaveBeenCalledWith(
        'http://localhost:8080/torrent/search',
        { params: { keyword: '测试' } }
      );
    });

    // expect(await screen.findByText('测试种子1')).toBeInTheDocument();
    // expect(await screen.findByText('测试种子2')).toBeInTheDocument();
  });
});
