// // src/pages/Home.jsx
// import React from 'react';
// import TorrentList from '../components/torrentlist';
// import { Link } from 'react-router-dom';

// const Home = () => {
//   return (
//     <div className="min-h-screen bg-gray-100 p-4">
//       <div className="flex justify-between items-center mb-4">
//         <h1 className="text-2xl font-bold">种子列表</h1>
//         <Link to="/upload" className="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
//           上传种子
//         </Link>
//       </div>
//       <TorrentList />
//     </div>
//   );
// };

// export default Home;
import React, { useState, useEffect } from 'react';
import { Link } from 'react-router-dom';
import TorrentList from '../components/torrentlist';
import Post from '../components/Post';
import FriendManager from '../components/FriendManager';
import ChatBox from '../components/ChatBox';
import RequestBoard from '../components/RequestBoard';
import { getActivityPreviews, getFullActivities } from '../api/activity';

const Home = () => {
  const currentUser = {
    id: 1,
    username: '测试用户',
  };

  const [selectedRelation, setSelectedRelation] = useState(null);
  const [activityPreviews, setActivityPreviews] = useState([]);
  const [fullActivities, setFullActivities] = useState([]);
  const [selectedActivityId, setSelectedActivityId] = useState(null);

  useEffect(() => {
    getActivityPreviews().then(res => setActivityPreviews(res.data));
    getFullActivities().then(res => setFullActivities(res.data));
  }, []);

  const selectedActivity = fullActivities.find(
    activity => activity.activityid === selectedActivityId
  );

  return (
    <div className="min-h-screen bg-gray-100 p-6">
      <div className="flex justify-between items-center mb-6">
        <h1 className="text-3xl font-bold">Pt站</h1>
        <Link to="/upload" className="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
          上传种子
        </Link>
      </div>

      {/* 种子列表区域 */}
      <div className="bg-white p-4 rounded shadow mb-8">
        <h2 className="text-xl font-semibold mb-4">种子列表</h2>
        <TorrentList />
      </div>

      {/* 活动区域 */}
      <div className="bg-white p-4 rounded shadow mb-8">
        <h2 className="text-xl font-semibold mb-4">活动预览</h2>
        {!selectedActivity ? (
          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
            {activityPreviews.map(activity => (
              <div key={activity.activityid} className="border p-3 rounded shadow">
                <h3 className="text-lg font-medium mb-2">{activity.title}</h3>
                <img
                  src={activity.photo}
                  alt={activity.title}
                  className="w-full h-40 object-cover mb-2 rounded"
                />
                <button
                  className="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                  onClick={() => setSelectedActivityId(activity.activityid)}
                >
                  查看详情
                </button>
              </div>
            ))}
          </div>
        ) : (
          <div className="p-4 border rounded shadow">
            <button
              className="mb-4 text-blue-600 underline"
              onClick={() => setSelectedActivityId(null)}
            >
              ← 返回列表
            </button>
            <h3 className="text-2xl font-bold mb-2">{selectedActivity.title}</h3>
            <img
              src={selectedActivity.photo}
              alt={selectedActivity.title}
              className="w-full h-60 object-cover rounded mb-4"
            />
            <p className="mb-2"><strong>内容：</strong>{selectedActivity.content}</p>
            <p className="mb-2"><strong>时间：</strong>{selectedActivity.time}</p>
            <p className="mb-2"><strong>奖励：</strong>{selectedActivity.award}</p>
          </div>
        )}
      </div>

      {/* 主内容区 */}
      <div className="grid grid-cols-1 xl:grid-cols-3 gap-8">
        {/* 帖子区域 */}
        <div className="bg-white p-4 rounded shadow xl:col-span-1">
          <h2 className="text-xl font-semibold mb-4">最新帖子</h2>
          <Post />
        </div>

        {/* 好友管理区 */}
        <div className="bg-white p-4 rounded shadow xl:col-span-1">
          <h2 className="text-xl font-semibold mb-4">好友管理</h2>
          <FriendManager
            currentUser={currentUser}
            onSelectRelation={setSelectedRelation}
          />
        </div>

        {/* 聊天窗口 */}
        {selectedRelation && (
          <div className="bg-white p-4 rounded shadow xl:col-span-1">
            <h2 className="text-xl font-semibold mb-4">聊天窗口</h2>
            <ChatBox
              senderId={currentUser.id}
              receiverId={selectedRelation.friendId}
            />
          </div>
        )}
      </div>

      {/* 求助帖区域 */}
      <div className="bg-white p-4 mt-8 rounded shadow">
        <h2 className="text-xl font-semibold mb-4">求助帖管理</h2>
        <RequestBoard currentUserId={currentUser.id} />
      </div>
    </div>
  );
};

export default Home;