import axios from 'axios';

const BASE_URL = 'http://localhost:8080/activity';

// 获取所有 is_show == 0 的活动预览（只含标题和图片）
export const getActivityPreviews = () => {
    return axios.get(`${BASE_URL}/preview`);
};

// 获取所有 is_show == 0 的完整活动信息
export const getFullActivities = () => {
    return axios.get(`${BASE_URL}/full`);
};

// 创建新的活动公告（使用 FormData 传递）
export const createActivity = (formData) => {
    return axios.post(`${BASE_URL}/create`, formData, {
        headers: {
            'Content-Type': 'multipart/form-data',
        },
    });
};

// 删除活动公告（通过 ID）
export const deleteActivity = (id) => {
    return axios.delete(`${BASE_URL}/delete/${id}`);
};

// 获取所有活动（无论展示状态）
export const getAllActivities = () => {
    return axios.get(`${BASE_URL}/all`);
};

// 修改活动公告（使用 FormData 传递）
export const updateActivity = (formData) => {
    return axios.put(`${BASE_URL}/update`, formData, {
        headers: {
            'Content-Type': 'multipart/form-data',
        },
    });
};

// 根据标题搜索活动
export const searchActivitiesByTitle = (title) => {
    return axios.get(`${BASE_URL}/search`, {
        params: { title },
    });
};
