import axios from 'axios';

const BASE_URL = 'http://localhost:8080/chat';

// 创建聊天记录
export const createChat = (chatData) => {
    return axios.post(`${BASE_URL}/create`, chatData);
};

// 删除聊天记录
export const deleteChat = (chatId) => {
    return axios.delete(`${BASE_URL}/delete/${chatId}`);
};

// 获取某个用户的所有聊天记录（与所有人的）
export async function getChatsByUser(userId) {
    try {
        const response = await axios.get(`${BASE_URL}/user/${userId}`);
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('获取用户聊天记录失败', error);
        return [];
    }
}

// 获取两个用户之间的聊天记录（请求参数形式）
export async function getChatsBetweenUsers(user1Id, user2Id) {
    try {
        const response = await axios.get(`${BASE_URL}/between`, {
            params: {
                user1: user1Id,
                user2: user2Id
            }
        });
        return Array.isArray(response.data) ? response.data : [];
    } catch (error) {
        console.error('获取两人聊天记录失败', error);
        return [];
    }
}
