import axios from 'axios';

const BASE_URL = 'http://localhost:8080/complain';

// 创建投诉
export const createComplain = async (complainData) => {
    try {
        const response = await axios.post(`${BASE_URL}/create`, complainData);
        return response.data;
    } catch (error) {
        console.error('创建投诉失败:', error);
        throw error;
    }
};

// 删除投诉（根据 complainid）
export const deleteComplain = async (complainid) => {
    try {
        const response = await axios.delete(`${BASE_URL}/delete/${complainid}`);
        return response.data;
    } catch (error) {
        console.error('删除投诉失败:', error);
        throw error;
    }
};

// 更新投诉
export const updateComplain = async (complainData) => {
    try {
        const response = await axios.put(`${BASE_URL}/update`, complainData);
        return response.data;
    } catch (error) {
        console.error('更新投诉失败:', error);
        throw error;
    }
};

// 获取某个被投诉用户的所有投诉记录（根据 duser）
export const getComplainsByTargetUser = async (duser) => {
    try {
        const response = await axios.get(`${BASE_URL}/target/${duser}`);
        return response.data;
    } catch (error) {
        console.error('获取被投诉用户的投诉记录失败:', error);
        throw error;
    }
};

// 获取某个投诉发起者的所有投诉记录（根据 puse）
export const getComplainsByPostingUser = async (puse) => {
    try {
        const response = await axios.get(`${BASE_URL}/from/${puse}`);
        return response.data;
    } catch (error) {
        console.error('获取用户提交的投诉记录失败:', error);
        throw error;
    }
};

// ✅ 获取所有投诉记录
export const getAllComplains = async () => {
    try {
        const response = await axios.get(`${BASE_URL}/all`);
        return response.data;
    } catch (error) {
        console.error('获取所有投诉记录失败:', error);
        throw error;
    }
};

// ✅ 根据投诉 ID 获取详情（包含投诉用户、被投诉用户、种子号等）
export const getComplainDetailById = async (complainid) => {
    try {
        const response = await axios.get(`${BASE_URL}/detail/${complainid}`);
        return response.data;
    } catch (error) {
        console.error('获取投诉详情失败:', error);
        throw error;
    }
};
