import axios from 'axios';

const BASE_URL = 'http://localhost:8080/friends';

// 添加好友（发起好友请求）
export const addFriend = (friendData) => {
    return axios.post(`${BASE_URL}/add`, friendData);
};

// 同意好友申请
export const acceptFriend = (friend1, friend2) => {
    return axios.post(`${BASE_URL}/accept`, null, {
        params: { friend1, friend2 }
    });
};

// 拒绝好友申请（删除 pending 状态的好友关系）
export const rejectFriend = (friend1, friend2) => {
    return axios.delete(`${BASE_URL}/delete`, {
        params: { friend1, friend2 }
    });
};

// 删除好友
export const deleteFriend = (friend1, friend2) => {
    return axios.delete(`${BASE_URL}/delete`, {
        params: { friend1, friend2 }
    });
};

// 查询某用户所有已通过好友
export const getFriendsByUserId = (userid) => {
    return axios.get(`${BASE_URL}/list/${userid}`);
};

// 查询某用户收到的好友申请（pending 状态）
export const getPendingRequests = (userid) => {
    return axios.get(`${BASE_URL}/pending/${userid}`);
};
