const BASE_URL = 'http://localhost:8080/post';

/**
 * 创建帖子（带图片）
 * @param {FormData} formData 包含 userid、post_title、post_content、tags、rannge、is_pinned、photo
 */
export const createPost = (formData) => {
    return fetch(`${BASE_URL}/create`, {
        method: 'POST',
        body: formData,
    }).then(res => res.json());
};

/**
 * 切换置顶状态
 * @param {number} postid 帖子 ID
 */
export const togglePinPost = (postid) => {
    return fetch(`${BASE_URL}/togglePin/${postid}`, {
        method: 'PUT',
    }).then(res => res.json());
};

/**
 * 删除帖子
 * @param {number} postid 帖子 ID
 */
export const deletePost = (postid) => {
    return fetch(`${BASE_URL}/delete/${postid}`, {
        method: 'DELETE',
    }).then(res => res.json());
};

/**
 * 更新帖子（JSON 格式）
 * @param {Object} post 帖子对象
 */
export const updatePost = (post) => {
    return fetch(`${BASE_URL}/update`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(post),
    }).then(res => res.json());
};

/**
 * 关键词搜索帖子
 * @param {string} keyword 搜索关键词
 */
export const searchPosts = (keyword) => {
    return fetch(`${BASE_URL}/search?keyword=${encodeURIComponent(keyword)}`)
        .then(res => res.json());
};

/**
 * 点赞帖子
 * @param {number} postid 帖子 ID
 */
export const likePost = (postid) => {
    return fetch(`${BASE_URL}/like/${postid}`, {
        method: 'PUT',
    }).then(res => res.json());
};

/**
 * 取消点赞帖子
 * @param {number} postid 帖子 ID
 */
export const unlikePost = (postid) => {
    return fetch(`${BASE_URL}/unlike/${postid}`, {
        method: 'PUT',
    }).then(res => res.json());
};

/**
 * 置顶帖子
 * @param {number} postid 帖子 ID
 */
export const pinPost = (postid) => {
    return fetch(`${BASE_URL}/pin/${postid}`, {
        method: 'PUT',
    }).then(res => res.json());
};

/**
 * 取消置顶帖子
 * @param {number} postid 帖子 ID
 */
export const unpinPost = (postid) => {
    return fetch(`${BASE_URL}/unpin/${postid}`, {
        method: 'PUT',
    }).then(res => res.json());
};

/**
 * 获取某用户所有帖子
 * @param {number} userid 用户 ID
 */
export const findPostsByUserId = (userid) => {
    return fetch(`${BASE_URL}/findByUserid?userid=${userid}`)
        .then(res => res.json());
};

/**
 * 获取所有置顶帖子
 */
export const findPinnedPosts = () => {
    return fetch(`${BASE_URL}/findPinned`)
        .then(res => res.json());
};

/**
 * 获取所有帖子（排序后）
 */
export const getAllPostsSorted = () => {
    return fetch(`${BASE_URL}/all`)
        .then(res => res.json());
};

/**
 * 根据 postid 获取帖子详情（若你后期需要）
 */
export const getPostById = (postid) => {
    return fetch(`${BASE_URL}/get/${postid}`)
        .then(res => res.json());
};
