import React from 'react';
import { Avatar } from 'antd';
import frameImage from './avatar-frame.png'; // 头像框图片素材
import './AvatarWithFrame.css';

const AvatarWithFrame = () => {
  // 从localStorage获取用户数据
  const userData = JSON.parse(localStorage.getItem('user')) || {};
  const { image, decoration = '' } = userData;

  // 检查是否包含头像框
  const hasFrame = decoration.includes('头像框');

  return (
    <div className="avatar-container">
      {/* 头像 */}
      <Avatar 
        src={image} 
        size={80}
        className={`user-avatar ${hasFrame ? 'with-frame' : ''}`}
      />
      
      {/* 头像框图片 - 根据decoration显示 */}
      {hasFrame && (
        <img 
          src={frameImage} 
          alt="头像框" 
          className="avatar-frame-image"
        />
      )}
    </div>
  );
};

export default AvatarWithFrame;