import React from 'react';
import { Link, useNavigate, useLocation } from 'react-router-dom';
import { Layout, Menu, Avatar } from 'antd';
import {
  HomeOutlined,
  CloudUploadOutlined,
  ThunderboltOutlined,
  UsergroupAddOutlined
} from '@ant-design/icons';

const { Header } = Layout;

const Navbar = () => {
  const navigate = useNavigate();
  const location = useLocation();

  // 从localStorage获取用户数据
  const userData = JSON.parse(localStorage.getItem('user')) || {};
  const { username, image } = userData;

  // 点击头像或用户名跳转到首页
  const handleUserClick = () => {
    navigate('/usercenter');
  };

  return (
    <Header
      style={{
        backgroundColor: '#f5be42',
        boxShadow: '0 2px 8px rgba(0,0,0,0.15)',
        padding: '0 40px',
         width: '100%', // 确保宽度扩展到100%
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'space-between'
      }}
    >
      {/* Logo */}
      <div style={{ color: '#fff', fontSize: '20px', fontWeight: 'bold' }}>
        <Link to="/" style={{ color: '#fff', textDecoration: 'none' }}>
          社交互动平台
        </Link>
      </div>

      {/* Menu */}
      <Menu
        mode="horizontal"
        theme="dark"
        selectedKeys={[location.pathname]}
        style={{
          backgroundColor: 'transparent',
          flex: 1,
          justifyContent: 'center',
          borderBottom: 'none'
        }}
      >
        <Menu.Item key="/mainpage" icon={<HomeOutlined />}>
          <Link to="/home" style={{ color: '#fff' }}>首页</Link>
        </Menu.Item>
        <Menu.Item key="/" icon={<HomeOutlined />}>
          <Link to="/community" style={{ color: '#fff' }}>社区</Link>
        </Menu.Item>
        <Menu.Item key="/torrents" icon={<ThunderboltOutlined />}>
          <Link to="/torrents" style={{ color: '#fff' }}>种子</Link>
        </Menu.Item>
        <Menu.Item key="/upload" icon={<CloudUploadOutlined />}>
          <Link to="/upload" style={{ color: '#fff' }}>上传种子</Link>
        </Menu.Item>
        <Menu.Item key="/friend" icon={<UsergroupAddOutlined />}>
          <Link to="/friend" style={{ color: '#fff' }}>好友</Link>
        </Menu.Item>
        <Menu.Item key="/shop" icon={<UsergroupAddOutlined />}>
          <Link to="/shop" style={{ color: '#fff' }}>商城</Link>
        </Menu.Item>
      </Menu>

      {/* 用户名和头像 - 添加点击事件 */}
      <div
        style={{
          display: 'flex',
          alignItems: 'center',
          gap: '8px',
          cursor: 'pointer'  // 添加指针样式表示可点击
        }}
        onClick={handleUserClick}
      >
        <Avatar
          src={image}
          size="default"
          style={{ backgroundColor: '#f56a00' }}
        />
        <span style={{ color: '#fff' }}>{username}</span>
      </div>
    </Header>
  );
};

export default Navbar;