import React, { useEffect, useState } from 'react';
import '../torrentlist.css';

const RecommendAll = () => {
  const [torrents, setTorrents] = useState([]);
  const storedUser = localStorage.getItem('user');
    //let currentUserId = null; // 初始化为 null
    let currentUserId = null; // 初始化为 null

    if (storedUser) {
        try {
            const parsedUser = JSON.parse(storedUser);
            currentUserId = parsedUser.userid; // 直接赋值
        } catch (error) {
            console.error('解析用户数据失败:', error);
            // 可以在这里处理 JSON 解析错误（如数据损坏）
        }
    } else {
        console.log('用户未登录');
    }

    // 现在 currentUserId 可以在后续逻辑中使用
    console.log('当前用户ID:', currentUserId);


  useEffect(() => {
    const fetchAll = async () => {
   const res = await fetch(`http://localhost:8080/recommend/list?userId=${currentUserId}`);
    //const res = await fetch('http://localhost:8080/torrent/list');
      const data = await res.json();
      setTorrents(data);
    };
    fetchAll();
  }, []);

  const formatFileSize = (bytes) => {
    if (!bytes) return '0 Bytes';
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(1024));
    return (bytes / Math.pow(1024, i)).toFixed(2) + ' ' + sizes[i];
  };

  return (
    <div className="torrents-container">
      <h2 style={{ fontSize: 24, fontWeight: 'bold', marginBottom: 16 }}>全部推荐种子</h2>
      <div className="torrents1-grid">
        {torrents.map(torrent => (
          <div key={torrent.torrentid} className="torrent-card">
            <div className="cover">
              {torrent.coverImagePath ? (
                <img src={torrent.coverImagePath} alt="封面" className="cover-image" />
              ) : (
                <div className="no-cover">无封面</div>
              )}
            </div>

            <div className="info">
              <h3 className="title" title={torrent.filename}>
                {torrent.torrentTitle || torrent.filename}
              </h3>
              <p className="description" title={torrent.description}>
                {torrent.description || '暂无描述'}
              </p>

              <div className="details">
                <span>大小: {formatFileSize(torrent.torrentSize)}</span>
                <span>上传时间: {new Date(torrent.uploadTime).toLocaleDateString()}</span>
                <span>下载次数: {torrent.downloadCount}</span>
              </div>

              <div className="actions">
                <button className="btn btn-download">下载</button>
                <a href={`/torrent/${torrent.torrentid}`} className="btn btn-detail">详情</a>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default RecommendAll;
