import introJs from 'intro.js';

export const startIntroGuide = () => {
  introJs().setOptions({
    steps: [
      {
        intro: '欢迎加入我们，这是一个优质的种子资源分享社区。让我们快速了解一下主要功能，帮助您更好地使用我们的平台。'
      },
     {
        element: document.querySelector('#torrent-activity'),
        intro: '这里是首页，包括近期活动速递，资源推荐，您可以浏览最新活动，参加领取奖励，提升您的等级！'
      },
      {
        element: document.querySelector('#community-posts'),
        intro: '这里是社区交流中心，您可以发布帖子、评论互动、发布需求贴悬赏求助，还能查看我的帖子！'
      },
      {
        element: document.querySelector('#torrent-list'),
        intro: '这里是全站种子列表，您可以按分类浏览、搜索特定资源、查看详细信息和下载种子文件。所有优质资源都在这里！'
      },
      {
        element: document.querySelector('#torrent-upload'),
        intro: '这是快速上传种子入口，操作简单易上手，快来上传你的第一个资源！'
      },
      {
        element: document.querySelector('#community-friends'),
        intro: '这里是好友聊天区，您可以添加和管理好友、畅聊分享！'
      },
      {
        element: document.querySelector('#torrent-shop'),
        intro: '用您的积分兑换个人装饰、上传量和邀请码，提升使用体验，邀请更多好友。'
      },
      {
        element: document.querySelector('#help-button'),
        intro: '小贴士：您可以随时点击右上角的帮助按钮重新查看引导和查看文档。祝您使用愉快！'
      }
    ],
    nextLabel: '下一步',
    prevLabel: '上一步',
    skipLabel: '跳过',
    doneLabel: '完成'
  }).start();
};
